######################################################################
# author: M. Rehr
# LaMo: 2012-03-04
######################################################################

############################################## Break Detection
##
## Break Detection
##    deseasonalize
##    kz_kza
##    xy_breaks_base
##    xy_breaks_layer
##
##############################################

######################################################################
# Break Detection
######################################################################

###########################
## @knitr deseasonalize
## add deseasonalized data
nD <- by(data, data$Station, deseasonalize, freq=freq)
data <- nD[[1]]
for(i in 2:length(nD)){
  data <- rbind(data, nD[[i]])
}
###########################

###########################
## @knitr kz_kza
# compute and plot kz and kza (overview method functioning)
kz <- kz.f.sd(x=Value, t=ts$Time, m=m, it=it)
kza <- kza.f.sd(kz=kz, it.kza=it.kza)
# plot 
par(mfcol=c(4,2), mar=c(2.5,2.7,1.2,.7), cex=1, lwd=2.8, cex.lab=1, cex.axis=0.7, mgp=c(1.7,0.4,0), tcl=-.3, las=1)
plot.kza(kz=kz, q1=0.75, q2=0.95, tn=5, anticipated=a)
plot.kza(kz=kz, kza=kza, q1=0.75, q2=0.95, tn=5, anticipated=a)
###########################

###########################
## @knitr xy_breaks_base  
# xyplot break detection
xyplot(values ~ Time | Station, data=data, times=times, changes=changes,
       ww=m, it.kz=it.kz, it.kza=it.kza, col=col, ylim=ylim,
       layout=layout, ylab=parse(text=ylab), xlab=xlab, scales=scales,
       panel = function(x, y, times, ww, it.kz, it.kza, col, ...) {
        panel.fct.break(x, y, times, ww, it.kz, it.kza, col)
       }, key=key)
###########################

###########################
## @knitr xy_breaks_layer
# layers for xyplot break detection
xyplot(values ~ Time | Station, data=data,
       ww=m, it.kz=it.kz, it.kza=it.kza, col=col, place=place,
       panel = function(x, y, ww, it.kz, it.kza, col, place, ...) {
        panel.fct.break.layer(x, y, ww, it.kz, it.kza, col, place)
       }) 
###########################

######################################################################
######################################################################