######################################################################
# author: M. Rehr
# LaMo: 2012-03-04
######################################################################

############################################## Outlier Detection
##
## Outlier Detection
##    static
##    q1
##    out_t
##    out_tt
##    out_z
##
##############################################

######################################################################
# Outlier Detection
######################################################################

###########################
## @knitr static
# outlier detection overview, no window
q <- 'static'
static <- xyplot(Value ~ Time | Station, data=data, q=q,
       layout=layout, scales=scales,                 
       ylab=parse(text=ylab), xlab=xlab,
       panel = function(x, y, q=q, text=FALSE, ...){
         panel.fct.overview(x,y,q,text)
         } )
plot(static)
caption <- cap.out(cp_name=cp_name, q=q, stat='all', transf='o')
###########################

###########################
## @knitr q1
# outlier detection overview, extremly narrow window
q <- 1
q1 <- xyplot(Value ~ Time | Station, data=data, q=q,
       layout=layout, scales=scales,
       ylab=parse(text=ylab), xlab=xlab,  
       panel = function(x, y, q=q, text=FALSE, ...){
         panel.fct.overview(x,y,q,text)
         } )
plot(q1)
caption <- cap.out(cp_name=cp_name, q=q, stat='all', transf='o')
###########################

###########################
## @knitr out_t
# outlier detection with Tukey heuristic
xy <- xyplot(Value ~ Time | Station, data=data, q=q,
            layout=layout, scales=scales,
            ylab=parse(text=ylab), xlab=xlab,  
            panel = function(x, y, q=q, nd=FALSE, text=FALSE, ...){
              panel.fct.tukey(x,y,q,nd,text)
            } ) 
plot(xy)
caption <- cap.out(cp_name=cp_name, q=q, stat='tukey', transf='o')
###########################

###########################
## @knitr out_tt
# outlier detection with Tukey heuristic, (approximately) normally distributed data
if (cp_name %in% c('pm10','co','so2','no2')) {
  transf <- 'log10'
  y_tfd <- data$log10Value
  ylab_tfd <- paste('log[10](', ylab, ')', sep='')
} else {
  if (cp_name == 'o3') {
    transf <- 'id'
    y_tfd <- data$Value
    ylab_tfd <- ylab
  }}

xy <- xyplot(y_tfd ~ Time | Station, data=data, q=q,
            layout=layout, scales=scales,
            ylab=parse(text=ylab_tfd), xlab=xlab,  
            panel = function(x, y, q=q, nd=TRUE, text=FALSE, ...){
              panel.fct.tukey(x,y,q,nd,text)
            } ) 
plot(xy)

caption <- cap.out(cp_name=cp_name, q=q, stat='tukey', transf=transf)
###########################

###########################
## @knitr out_z
# outlier detection with z heuristic, (approximately) normally distributed data
xy <- xyplot(y_tfd ~ Time | Station, data=data, q=q,
            layout=layout, scales=scales,
            ylab=parse(text=ylab_tfd), xlab=xlab,  
            panel = function(x, y, q=q, text=FALSE, ...){
              panel.fct.z(x,y,q,text)
            } ) 
plot(xy)
caption <- cap.out(cp_name=cp_name, q=q, stat='z', transf=transf)  
###########################

######################################################################
######################################################################