
## @knitr app_set_parent
set_parent('0-tech_rep.Rnw')


## @knitr DEM_cy_data
xlab <- make.xlab.DEM(cp_name)
ylab <- make.ylab(cp_name)
run_chunk('load_DEM')
run_chunk('DEM_cy')


## @knitr q2-4-6
q <- 2
run_chunk('out_t')
q <- 4
run_chunk('out_t')
q <- 6
run_chunk('out_t')


## @knitr DEM_o3_paths
opts_chunk$set(cache.path='./cache/DEM_o3/', fig.path='./figures/DEM_o3/', fig.lp='fig:DEM:')


## @knitr o3_cy
cp_name <- 'o3'
run_chunk('DEM_cy_data')


## @knitr o3_overview
run_chunk('static')
run_chunk('q1')


## @knitr o3_q2-4-6



## @knitr DEM_so2_paths
opts_chunk$set(cache.path='./cache/DEM_so2/', fig.path='./figures/DEM_so2/', fig.lp='fig:DEM:')


## @knitr so2_cy
cp_name <- 'so2'
run_chunk('DEM_cy_data')


## @knitr so2_overview
run_chunk('static')
run_chunk('q1')


## @knitr so2_q2-4-6



## @knitr DEM_no2_paths
opts_chunk$set(cache.path='./cache/DEM_no2/', fig.path='./figures/DEM_no2/', fig.lp='fig:DEM:')


## @knitr no2_cy
cp_name <- 'no2'
run_chunk('DEM_cy_data')


## @knitr no2_overview
run_chunk('static')
run_chunk('q1')


## @knitr no2_q2-4-6



## @knitr DEM_co_paths
opts_chunk$set(cache.path='./cache/DEM_co/', fig.path='./figures/DEM_co/', fig.lp='fig:DEM:')


## @knitr co_cy
cp_name <- 'co'
run_chunk('DEM_cy_data')


## @knitr co_overview
run_chunk('static')
run_chunk('q1')


## @knitr co_q2-4-6



## @knitr AirBase_CZ_data
run_chunk('load_CZ')
if (cp_period=="day"){k <- 10
                      freq <- 365} else {
  if (cp_period=="hour"){k <- 120
                         freq <- 365*24}}
run_chunk('runs')
run_chunk('deseasonalize')


## @knitr params_window_hour
values <- data$Value
it.kz <- it.kza <- 3
ylab <- make.ylab(cp_name)
ww_colors <- c(1,4,3,6)
key <- list(x=0.999, y=0.99, corner=c(1,1), title="window widths & thresholds",
            cex.title=0.9, background=grey(.95), padding.text=2, between=1.8,
            lines=list(col=ww_colors),
            text=list(c("1 week", "2 weeks", "1 month", "2 months")), 
            points=list(pch=25, fill=c("yellow", "orange", 2)),
            text=list(c("0.95", "0.975", "0.995")), rep=FALSE)


## @knitr kza_ww_hour
m <- 7*24
col <- ww_colors[1]
m7_base <- run_chunk('xy_breaks_base')
m <- 15*24 
col <- ww_colors[2]
place <- 1*offset
m15 <- run_chunk('xy_breaks_layer')
m <- 31*24 
col <- ww_colors[3]
place <- 2*offset
m31 <- run_chunk('xy_breaks_layer')
m <- 61*24 
col <- ww_colors[4]
place <- 3*offset
m61 <- run_chunk('xy_breaks_layer')
m7_base+as.layer(m15)+as.layer(m31)+as.layer(m61)


## @knitr AirBase_pm10_paths_hour
opts_chunk$set(cache.path='./cache/AirBase_pm10/', fig.path='./figures/AirBase_pm10/', fig.lp='fig:AirBase:')


## @knitr pm10_CZ_hour
cp_name <- 'pm10'
cp_period <- 'hour'
run_chunk('AirBase_CZ_data')


## @knitr ww_plot_pm10
run_chunk('params_window_hour')
ylim <- c(-20,380)
offset <- 260/4
run_chunk('kza_ww_hour')


## @knitr ww_plot_pm10_des
ylim <- c(-50,340)
offset <- 220/4
values <- data$newValue
ylab <- paste(ylab, "deseasonalized~measurements", sep="~")
run_chunk('kza_ww_hour')


## @knitr AirBase_so2_paths
opts_chunk$set(cache.path='./cache/AirBase_so2/', fig.path='./figures/AirBase_so2/', fig.lp='fig:AirBase:')


## @knitr so2_CZ_hour
cp_name <- 'so2'
cp_period <- 'hour'
run_chunk('AirBase_CZ_data')


## @knitr ww_plot_so2
run_chunk('params_window_hour')
ylim <- c(-10,140)
offset <- 100/4
run_chunk('kza_ww_hour')


## @knitr ww_plot_so2_des
ylim <- c(-50,120)
offset <- 80/4
values <- data$newValue
ylab <- paste(ylab, "deseasonalized~measurements", sep="~")
run_chunk('kza_ww_hour')


## @knitr AirBase_o3_paths
opts_chunk$set(cache.path='./cache/AirBase_o3/', fig.path='./figures/AirBase_o3/', fig.lp='fig:AirBase:')


## @knitr o3_CZ_hour
cp_name <- 'o3'
cp_period <- 'hour'
run_chunk('AirBase_CZ_data')


## @knitr ww_plot_o3
run_chunk('params_window_hour')
ylim <- c(-20,320)
offset <- 200/4
run_chunk('kza_ww_hour')


## @knitr ww_plot_o3_des
ylim <- c(-40,220)
offset <- 100/4
values <- data$newValue
ylab <- paste(ylab, "deseasonalized~measurements", sep="~")
run_chunk('kza_ww_hour')


