
## @knitr set_global_options
options(width=80, scipen = 1, digits = 4)
opts_knit$set(aliases=c(h='fig.height', w='fig.width'), eval.after='fig.cap', self.contained=FALSE)
on <- FALSE
opts_chunk$set(echo=on, warning=on, error=on, message=on, cache=TRUE, autodep=TRUE, dev='png', dev.args=list(antialias='cleartype'), dpi=150, fig.pos='H', out.width='.9\\linewidth', fig.align='center', par_base=TRUE, par_lattice=TRUE)
# tune details of base graphics (http://yihui.name/knitr/hooks)
knit_hooks$set(par_base=function(before, options, envir){if (before) par(mar=c(0.2,4.7,1.2,0.7), cex.lab=1, cex.axis=0.7, mgp=c(3,0.7,0), tcl=-0.3, las=1)})
#
opts_template$set(cy_figures = list(fig.width = 11, fig.height = 6))
opts_template$set(AirBase_figures = list(fig.width = 11, fig.height = 9))
opts_template$set(AirBase_figures_app = list(fig.width = 11, fig.height = 7))


## @knitr read_Rcode
read_chunk("A-settings_and_data.R")
read_chunk("B-preliminary_data_analysis.R")
read_chunk("C-outlier_detection.R")
read_chunk("D-break_detection.R")


## @knitr settings
# set path

#getwd()
#"C:/Users/mrehr_01/Documents/ETC-ACM/subtask 1.0.1.2-5b"
#set to "C:/Users/mrehr_01/Documents/ETC-ACM/subtask 1.0.1.2-5b/Scripts"
#path <- './Scripts'
#setwd(path)


# load scripts and packages

# preliminary data analysis:
source("./helper_functions/helper_settings.R")
source("./helper_functions/helper_prelim.R")
library(Hmisc)          # describe  
library(lattice)        # xyplot   
library(latticeExtra)   # xyplot.stl, as.layer
library(zoo)            # zoo ts objects
# outlier detection (additionally):
source("./helper_functions/helper_out.R")
library(caTools)        # runquantile
# break detection (additionally):
source("./helper_functions/helper_break.R")
library(kza)            # Kolmogorov-Zurbenko (adaptive) filter


# tune details of lattice graphics

# non-graphical options
lattice.options(default.args=list(as.table=TRUE, aspect="xy"))
# scales parameter for lattice graphics
scales <- list(tck=c(0.8,0), alternating=c(1,0), cex=1.2)
# graphical options
knit_hooks$set(par_lattice=function(before, options, envir){if (before)  
  trellis.par.set(list(strip.background=list(col=grey(.95)), 
                       par.xlab.text=list(cex=1.3), 
                       par.ylab.text=list(cex=1.3)
                       )) })
###########################

######################################################################
# DEM data
######################################################################

# read DEM (component-wise: pm10, co, so2, no2, o3)
#cp_name <- "pm10"
# "co"
# "so2"
# "no2"
# "o3"

###########################


## @knitr child_Preliminaries

source("4-Preliminaries.R")


## @knitr child_Outliers

source("5-Outlier.R")


## @knitr child_Breaks

source("6-Break.R")


## @knitr child_Appendix

source("8-Appendix.R")


